%% Zadanie1 pre jednotlive skupiny
% a) V 2D nazorne ukazat, ze vlastnost postupnej aproximacie plati   pre ortonormalne bazy
% b) V 2D nazorne ukazat, ze vlastnost postupnej aproximacie NEplati pre Neortogonalne bazy
% c) Vytvorit jednoduche demo na kreslenie vektorov v 3D

clear all
close all
lnw = 2;
lnwh = 1;
hdw = 0.02;
%% a) V 2D nazorne ukazat, ze vlastnost postupnej aproximacie plati pre ortonormalne bazy
o3l2 = sqrt(3)/2;   % Odmocnina 3 Lomeno 2 => o3l2
x = [-0.5; -2];
B = [0.5 -o3l2; o3l2 0.5];
test_ortogonality = B(:,1)'*B(:,2)  % musi byt 0

x1 = x'*B(:,1)*B(:,1);      % priemet do prveho bazoveho vektora
x2 = x'*B(:,2)*B(:,2);      % priemet do druheho bazoveho vektora

x_rek = x1 + x2;            % rekonstrukcia resp. zlozenie; malo by vyjst x = x_rek

% zobrazenie
plot_2d_axis(-2,2,-2,2)
set(gcf,'name','Postupna aproximacia v ortonormalnej baze','NumberTitle','off')

plot_2d_vector( [0 0], B(:,1),'b_1', 'linewidth',lnw);
plot_2d_vector( [0 0], B(:,2),'b_2', 'linewidth',lnw);
plot_2d_vector( [0 0], x,'x', 'linewidth',lnw);
pause
plot_2d_vector( [0 0], x1,'x_1', 'linewidth',lnw,'color','blue');
plot_2d_vector( [0 0], x2,'x_2', 'linewidth',lnw,'color','blue');
pause
plot_2d_vector( [0 0], x_rek,'x_r_e_k', 'linewidth',lnw,'color','red');
plot_2d_vector( x1, x_rek,'', 'linewidth',lnwh,'headwidth',hdw);
plot_2d_vector( x2, x_rek,'', 'linewidth',lnwh,'headwidth',hdw);
pause


%% b) V 2D nazorne ukazat, ze vlastnost postupnej aproximacie NEplati pre Neortogonalne bazy
J = [2 3;1 2];
y = [-3; 1];

y1 = y'*J(:,1)/(J(:,1)'*J(:,1))*J(:,1);      % priemet do prveho bazoveho vektora
y2 = y'*J(:,2)/(J(:,2)'*J(:,2))*J(:,2);      % priemet do druheho bazoveho vektora

y_rek = y1 + y2;            % rekonstrukcia resp. zlozenie; nemoze vyjst y = y_rek

% zobrazenie
plot_2d_axis(-5,5,-5,5)
set(gcf,'name','Postupna aproximacia v neortonormalnej baze','NumberTitle','off')

plot_2d_vector( [0 0], J(:,1),'j_1', 'linewidth',lnw);
plot_2d_vector( [0 0], J(:,2),'j_2', 'linewidth',lnw);
plot_2d_vector( [0 0], y,'y', 'linewidth',lnw);
pause
plot_2d_vector( [0 0], y1,'y_1', 'linewidth',lnw,'color','blue');
plot_2d_vector( [0 0], y2,'y_2', 'linewidth',lnw,'color','blue');
pause
plot_2d_vector( [0 0], y_rek,'y_r_e_k', 'linewidth',lnw,'color','red');
plot_2d_vector( y1, y_rek,'', 'linewidth',lnwh,'headwidth',hdw);
plot_2d_vector( y2, y_rek,'', 'linewidth',lnwh,'headwidth',hdw);
pause

%% c) Vytvorit jednoduche demo na kreslenie vektorov v 3D

plot_3d_axis(-3,3,-3,3,-3,3)
a = [1 2 1];
b = [-1 1 0.5];
% zobrazenie
plot_3d_vector( [0 0 0], a,'a', 'linewidth',lnw);
plot_3d_vector( [0 0 0], b,'b', 'linewidth',lnw);
plot_3d_vector( a,a+b,'', 'linewidth',lnwh,'headwidth',hdw);
plot_3d_vector( b, a+b,'', 'linewidth',lnwh,'headwidth',hdw);
plot_3d_vector( [0 0 0], a+b,'a+b', 'linewidth',lnw,'color','red');

